/*
 * definitions for Fabric Management server
 */

#define FMS_MIN_POLL_WAIT 1000		/* check for work at least 1/sec */

/*
 * structure for all global data 
 */
struct fms_vars {

  int done;	/* set to 1 when time to exit */
  int debug;	/* enable debug output when true */
  
  char *fms_run;	/* base dir for fms stuff */

  char *db_name;	/* database name */
  struct db_database *database;

  struct fms_settings *settings;	/* user settings */

  struct fms_fma_info *fma_info;	/* FMA-related data */

  struct fms_state *state;		/* FMS state */

  struct fms_fabvars *fabvars;	/* fabric variables */

  struct fms_io_vars *io;	/* I/O related variables */

  struct fms_alert_vars *alert_vars;	/* alert handling subsystem */

  struct fms_notify *notify;	/* notification subsystem */

  struct fms_switch *switch_vars;	/* switch monitoring */

  struct fms_error_vars *error_vars;	/* error handling */
};

/*
 * function prototypes
 */
void fms_perror(void);
void fms_perror_exit(int);
void fms_exit(int);
int init_fabric_vars(void);
int init_fabric(void);
int load_fabric(void);
int init_alert_vars(void);
int init_alerts(void);
int init_switch_vars(void);
int init_switch_monitoring(void);
void fms_init_state_vars(void);
void fms_init_settings_vars(void);
void fms_init_settings(void);

/*
 * external definitions
 */

extern int errno;
extern struct fms_vars F;
